#include <stdio.h>
#include "print.h"

#define COMPRESS_FROM_OFFSET 0x64

int read_file(FILE* f, u8** out_buf, size_t* out_size);

int main() {
  u8* I; size_t I_size;
  FILE* fr = fopen("mozek.com", "rb"); if (!fr) die("Can't open mozek.com");
  if (read_file(fr, &I, &I_size)) return -1;
  fclose(fr);

  u8 C[4096] = {0}; size_t C_size = 0;  // commands
  u8 D[4096] = {0}; size_t D_size = 0;  // data

  int num_events[16] = {0};

  u8 last_byte = 0;
  for (int i=COMPRESS_FROM_OFFSET; i<I_size; i++) {
    if (i+2<I_size && I[i]==0x0f && I[i+1]==last_byte) {  // 0x0f, repeated byte
      C[C_size++] = 0;
      C[C_size++] = 1;
      num_events[0]++;
      i+=2;
    }
    else if (i+2<I_size && I[i]==0x0f) {  // 0x0f, new byte
      C[C_size++] = 0;
      C[C_size++] = 0;
      D[D_size++] = last_byte = I[i+1];
      num_events[1]++;
      i+=2;
    }
    else {  // literal
      C[C_size++] = 1;
      num_events[2]++;
    }
    D[D_size++] = I[i];
  }

  // part 1: compressed
  FILE* f1 = fopen("mozek1.pak", "wb"); if (!f1) die("Can't create mozek1.pak");
  fwrite(D, 1, D_size, f1);
  fclose(f1);

  // part 2: compressed
  FILE* f2 = fopen("mozek2.bit", "wb"); if (!f2) die("Can't create mozek2.bit");
  u8 bits[4096/8] = {0}; size_t bits_size = (C_size+7)/8;
  for (int i=0; i<C_size; i++) {
    int bit = bits_size*8 - 1 - i;
    bits[bit>>3] |= C[i] << (bit&7);
  }

  // merge last byte?
  u8* p_bits = bits;
  u8 last_bitmask = (C_size&7)==0 ? 0xFF : 0xFF00>>(C_size&7);
  if (bits[0] == (D[D_size-1] & last_bitmask)) {
    p_bits++;
    bits_size--;
  }

  fwrite(p_bits, 1, bits_size, f2);
  fclose(f2);

  // part 3: not compressed
  FILE* f3 = fopen("mozek3.raw", "wb"); if (!f3) die("Can't create mozek3.raw");
  fwrite(I, 1, COMPRESS_FROM_OFFSET, f3);
  fclose(f3);

  print("; '0F RR xx' * ", num_events[0], ": ", num_events[0]*3, " -> ", num_events[0]*(2+8)/8., " bytes");
  print("; '0F NN xx' * ", num_events[1], ": ", num_events[1]*3, " -> ", num_events[1]*(2+8+8)/8., " bytes");
  print(";       'xx' * ", num_events[2], ": ", num_events[2]*1, " -> ", num_events[2]*(1+8)/8., " bytes");
  print("; Total: ", num_events[0]*3 + num_events[1]*3 + num_events[2]*1, " -> ",
        num_events[0]*(2+8)/8. + num_events[1]*(2+8+8)/8. + num_events[2]*(1+8)/8., " bytes",
        p_bits==bits ? "" : " - 1 (merged)");

  // print init and unpacker code
  print("org 0x100");

  print("  call COMPRESSED_SKIP");
  print("COMPRESSED_DATA:");
  print("incbin \"mozek1.pak\"");
  print("incbin \"mozek2.bit\"");
  print("COMPRESSED_SKIP:");
  print("  pop si");
  print("  mov di,UNPACKED");
  print("  mov bx,COMPRESSED_SKIP-32");
  print("UNPACK:");
  print("  bt [bx],cx");
  print("  jc BIT1");
  print("  dec cx");        // make sure that cx doesn't become 0 here
  print("  bt [bx],cx");
  print("  jc BIT01");
  print("BIT00:");          // 00: 0x0f, new byte, literal
  print("  dec si");
  print("  lodsw");         // -> ah
  print("BIT01:");          // 01: 0x0f, repeated byte, literal
  print("  mov al,0x0f");
  print("  stosw");
  print("BIT1:");           // 1: literal
  print("  movsb");
  print("  loop UNPACK");
  print("incbin \"mozek3.raw\"");
  print("UNPACKED:");

  return 0;
}


// Read the whole file into a newly allocated buffer.
// If the return value is 0:
// - out_buf contains the file with an appended '\0' byte,
// - out_size (optional) is the number of bytes read.
int read_file(FILE* f, u8** out_buf, size_t* out_size) {
  u8 *buf=0, *tmp;
  size_t done=0, read;

  if (!f || !out_buf) goto error;
  if (ferror(f)) goto error;

  for (size_t cap=0x10000; cap>done; cap *= 2) {
    tmp = (u8*)realloc(buf, cap);
    if (!tmp) goto error;
    buf = tmp;

    read = fread(buf+done, 1, cap-done, f);
    done += read;
    if (read == 0) break;
  }

  if (ferror(f)) goto error;

  tmp = (u8*)realloc(buf, done+1);
  if (!tmp) goto error;
  buf = tmp;

  buf[done] = '\0';

  *out_buf = buf;
  if (out_size) { *out_size = done; }
  return 0;

error:
  if (buf) { free(buf); }
  return -1;
}